<?php

const FILE = "var/abook.txt";
const DB = "sqlite:var/abook.sqlite";
const ABOOK = DB;	

set_error_handler(create_function(
	'$errno, $errstr, $errfile, $errline, $errcontext',
	'if (!error_reporting()) return;
	throw new ErrorException($errstr, 0, $errno, $errfile, $errline);'), -1);

spl_autoload_register(create_function(
    '$class',
    '$file = "class.$class.php";
     if (!file_exists($file)) return;
     require_once $file;'));

require_once 'Twig-1.3.0/lib/Twig/Autoloader.php';
Twig_Autoloader::register();
$twig = new Twig_Environment(new Twig_Loader_Filesystem("templates"));

if (isset($_REQUEST['action'])) {

    try {
	if (preg_match('/^[\w]+\//', ABOOK))
	    $abook = new Address_Book_File(FILE);
	else 
	    $abook = new Address_Book_DB(DB);

	switch (@$_REQUEST['action']) {
		// Nach dem Eintragen bleiben wir auf der Eintragsseite,
		// aber wir verhindern Duplikate, die mit RELOAD passieren
		case 'add':	if ($abook->add_entry($_REQUEST)) {
				    header("Location: $_SERVER[PHP_SELF]?action=add");
				    exit(0);
			    }
			    echo $twig->render("add.html", array());
			    exit;
			    break;

		// Suchen…
		case 'search':  $entries = null;
				$error = null;
				try {
				    $entries = $abook->search_entries($_REQUEST['pattern']);
				}
				catch (Address_Book_Exception $e) {
				    $error = $e->getMessage();
				}

				if (@$_REQUEST['format'] == 'table') {
				    if (is_numeric($_REQUEST['max'])) {
					$left = count($entries) - $_REQUEST['max'];
					if ($left > 0) 
					    $entries = array_slice($entries, 0, $_REQUEST['max']);
					else
					    $left = NULL;
				    }
				    echo $twig->render("results.html",
					array('entries' => $entries,
					'left' => $left, 'error' => $error));
				    exit;
				}
				echo $twig->render("search.html",
				    array('entries' => $entries, 'error' => $error));
				exit;
			    }
			    break;

    }
    catch (Address_Book_Exception $e) {
	header("Content-Type: text/plain; charset=utf-8");
	print "Address Book Exception: " . $e->getMessage();
	exit;
    }
    catch (Exception $e) {
	header("Content-Type: text/plain; charset=utf-8");
	print "Ohoh\n\n" . $e;
	exit;
    }
}

echo $twig->render("search.html", array());
