package Nagios;

use strict;
use warnings;

sub UNKNOWN { 3 }
sub CRITICAL { 2 }
sub WARNING { 1 }
sub OK { 0 }

1;

__END__

=head1 NAME

    Nagios - nagios support perl module

=head1 SYNOPSIS

    use Nagios;

    return NAGIOS::UNKNOWN;
    return NAGIOS::CRITICAL;
    return NAGIOS::WARNING;
    return NAGIOS::OK;

=head1 CONSTANTS

=head2 UNKNOWN()

Returns the "unknown" status (3).

=head2 CRITICAL()

Returns the "critical" status (2).

=head2 WARNING()

Returns the "warning" status (1).

=head2 OK()

Returns the "OK" status (0).

=cut
