package App::read_httpd_conf;

use 5.010;
use strict;
use warnings;
use Carp;
use File::Basename;
use Pod::Usage;

our $VERSION = '0.1';

sub main {
	shift if $_[0] eq __PACKAGE__;
	return read_file(@_) ? 0 : 1;
}

sub read_file {
    my ($file, $basedir) = @_;
    $basedir //= dirname $file;
    open(my $fh, '<', $file)
      or croak "Can't open $file: $!\n";
    say "# 1 $file";
    while (<$fh>) {
        if (s{\\$}{}) {
            chomp;
            $_ .= <$fh>;
            redo;
        }
        if (/^\s*include\s+(?<quote>["'])?(?<file>.*?)\k<quote>?\s*$/i) {
            my $file = $+{file} =~ m{^/} ? $+{file} : "$basedir/$+{file}";
            say "# $. $file INCLUDE $+{file}";
            read_file($_, $basedir) foreach (glob -d $file ? "$file/*" : $file);
            next;
        }

        print;
    }
    return 1;
}

1;

__END__

=head1 NAME

 App::read_httpd_conf

=head1 SYNOPSIS

 use App::read_httpd_conf;
 App::read_httpd_conf->main($file);

=head1 DESCRIPTION

This small package reads the apache config file and writes the parsed
and included files to the standard file descriptor. If you want to proceess
the output in your own script, do something like this:

  my $output;
  open(my $fh, '>', \$output);
  my $oldfh = select($fh); 
  App::read_httpd_conf->read_file($config));
  select($oldfh);

=head1 AUTHOR

Heiko Schlittermann L<hs@schlittermann.de>

=cut
