package App::read_httpd_conf;

use 5.010;
use strict;
use warnings;
use Carp;
use File::Basename;
use Pod::Usage;

our $VERSION = '0.1';

sub main {
	shift if $_[0] eq __PACKAGE__;
	return read_file(@_) ? 0 : 1;
}

sub read_file {
    my ($file, $basedir) = @_;
    $basedir //= dirname $file;
    open(my $fh, '<', $file)
      or croak "Can't open $file: $!\n";
    say "# 1 $file";
    while (<$fh>) {
        if (s{\\$}{}) {
            chomp;
            $_ .= <$fh>;
            redo;
        }
        if (/^\s*include\s+(?<quote>["'])?(?<file>.*?)\k<quote>?\s*$/i) {
            my $file = $+{file} =~ m{^/} ? $+{file} : "$basedir/$+{file}";
            say "# $. $file INCLUDE $+{file}";
            read_file($_, $basedir) foreach (glob -d $file ? "$file/*" : $file);
            next;
        }

        print;
    }
    return 1;
}

1;
