#! /usr/bin/perl
my $outfile = shift;

my $now = localtime;
chomp(my $version = `hg log -r . --template '{latesttag}-{latesttagdistance}-{node|short}\n'`);

if (defined $outfile) {
	open(STDOUT, '>',  $_ = $outfile) or die "Can't open $_: $!\n";
}

print <<_;
[% # autogenerated at $now by $0
   # included automatically via PRE_PROCESS
   vcs.version = "$version";
-%]
_

# zero timestamp does not work! Template/tpage will
# complain about "file not found"
utime 1, 1 => $outfile
