#! /usr/bin/perl
my $outfile = shift;

chomp(my $version = `hg log -r . --template '{latesttag}-{latesttagdistance}-{node|short}\n'`);
my $now = localtime;

open(my $output, '>',  $_ = $outfile) or die "Can't open $_: $!\n";

print {$output} <<_;
[%# autogenerated at $now by $0 %]
[% vcs.version = "$version"; %]
_

utime 0, 0 => $outfile;
