#! /usr/bin/perl
my $outfile = shift;

my $now = localtime;
chomp(my $version = `hg log -r . --template '{latesttag}-{latesttagdistance}-{node|short}\n'`);

if (defined $outfile) {
	open(STDOUT, '>',  $_ = $outfile) or die "Can't open $_: $!\n";
}

print <<_;
[%# autogenerated at $now by $0 %]
[% vcs.version = "$version"; %]
_

utime 0, 0 => $outfile
