/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "me8100.h"

int main(void){
  int err = 0;
  static int file_handle = -1;

  unsigned short ctrl_a;
  unsigned short value_a;

  printf("Write test, PID: %d\n", getpid());
  file_handle = open("/dev/me8100_0", O_RDWR, 0);

  if(file_handle < 0){
    printf("Cannot open path !\n");
    return 1;
  }

  /* Write.
   * HACK: The driver itself should remember the status
   * of the IRQ bits in its control register
   */
  ctrl_a = ME8100_CTL_ENIO | ME8100_CTL_SOURCE | ME8100_CTL_IRQ_MASK;
  err = ioctl(file_handle, ME8100_WRITE_CTRL_A, &ctrl_a);
  if (err) {
    fprintf(stderr, "Can't setup output to port A\n");
    return 1;
  }

  value_a = 0x00;
  for (value_a = 0x00; value_a < 0xffff; ++value_a) {
    ioctl(file_handle, ME8100_WRITE_DO_A, &value_a);
    printf("Wrote %04x\n", value_a);
    sleep(3);
  }

  err = close(file_handle);
  if(err){
    printf("Kann Pfad nicht schliessen\n");
    return 1;
  }

  return 0;
}
/*
	vim:sts=2 sw=2 aw ai sm:
*/
