/*
 * Source File : me8100_test_counter.c
 * Destination : me8100_test_counter
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the counter part 
 *   of the me8100 board. It configures the counters in mode 3 (symetric 
 *   devisor) with a counter value of 4. So each frequency of a signal 
 *   put in at CLK is devided by 4.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <linux/spinlock.h>

#include "../me8100.h"


int main(void){
  int err = 0;
  int minor = 0;
  int count = 0;
  static int file_handle = -1;

  unsigned char cctrl_0;
  unsigned char cctrl_1;
  unsigned char cctrl_2;
  unsigned char clvalue_0;
  unsigned char chvalue_0;
  unsigned char clvalue_1;
  unsigned char chvalue_1;
  unsigned char clvalue_2;
  unsigned char chvalue_2;

  printf("%c%3s", 27, "[2J");
  printf("<<<--- ME8100 TESTPROGRAM FOR COUNTER --->>>\n\n");

  /*
   * You can select up to four me8100 baords, if installed.
   * 0 is the first board.
   */
  printf("Please type in the Minor Device Number of Board to open : ");
  count = scanf("%d", &minor);
  if(!count){
    printf("Invalid Input !\n");
    return 1;
  }
  printf("Open path /dev/me8100_%d !\n\n", minor);
  
  switch(minor){
  case 0:
    file_handle = open("/dev/me8100_0", O_RDWR, 0);
    break;
  case 1:
    file_handle = open("/dev/me8100_1", O_RDWR, 0);
    break;
  case 2:
    file_handle = open("/dev/me8100_2", O_RDWR, 0);
    break;
  case 3:
    file_handle = open("/dev/me8100_3", O_RDWR, 0);
    break;
  default:
    printf("Invalid Input !\n");
    return 1;
  }

  if(file_handle < 0){
    printf("Cannot open path !\n");
    return 1;
  }

  /*
   * Counter 
   *
   * Now that you have access to the me8100 you have to configurate
   * the board according to your needs. 
   * The ME8100 has got 3 counters with 16 bit each. First you have
   * to configure the counters control register according to your needs.
   * Then you can write the proper value to the counter.
   */


  /*--------------- ALL COUNTER IN MODE 3 AND BINARY ------------------------*/

  printf("Please press return to test counter in mode 3/binary :\n");
  getchar();
  getchar();
  
  /* 
   * Configure COUNTER_0 as asynchronous devisor,
   * as binary counter and LSB/MSB.
   */
  cctrl_0 = 0x36; 
  err = ioctl(file_handle , ME8100_SETUP_COUNTER, &cctrl_0);
  if(err){
    printf("Cannot setup counter 0\n");
    return 1;
  }

  /* 
   * Configure COUNTER_1 as asynchronous devisor,
   * as binary counter and LSB/MSB.
   */
  cctrl_1 = 0x76;
  err = ioctl(file_handle , ME8100_SETUP_COUNTER, &cctrl_1);
  if(err){
    printf("Cannot setup counter 1\n");
    return 1;
  }

  /* 
   * Configure COUNTER_2 as asynchronous devisor,
   * as binary counter and LSB/MSB.
   */
  cctrl_2 = 0xB6;
  err = ioctl(file_handle , ME8100_SETUP_COUNTER, &cctrl_2);
  if(err){
    printf("Cannot setup counter 2\n");
    return 1;
  }


  /*---------------------------- LOAD COUNTER -------------------------------*/
  
  /* Counter 0 */
  clvalue_0 = 0x4;
  chvalue_0 = 0x0;
  /* Write lower byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_0, &clvalue_0);
  if(err){
    printf("Cannot write to counter 0\n");
    return 1;
  }
  /* Write higher byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_0, &chvalue_0);
  if(err){
    printf("Cannot write to counter 0\n");
    return 1;
  }

  /* Counter 1 */
  clvalue_1 = 0x4;
  chvalue_1 = 0x0;
  /* Write lower byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_1, &clvalue_1);
  if(err){
    printf("Cannot write to counter 1\n");
    return 1;
  }
  /* Write higher byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_1, &chvalue_1);
  if(err){
    printf("Cannot write to counter 1\n");
    return 1;
  }

  /* Counter 2 */
  clvalue_2 = 0x4;
  chvalue_2 = 0x0;
  /* Write lower byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_2, &clvalue_2);
  if(err){
    printf("Cannot write to counter 2\n");
    return 1;
  }
  /* Write higher byte */
  err = ioctl(file_handle , ME8100_WRITE_COUNTER_2, &chvalue_2);
  if(err){
    printf("Cannot write to counter 2\n");
    return 1;
  }



  /*-------------------------------- END ------------------------------------*/

  printf("Please press return to terminate program :\n");
  getchar();

  printf("Close path to me8100_%d\n", minor);
  err = close(file_handle);
  if(err){
    printf("Kann Pfad nicht schliessen\n");
    return 1;
  }

  return 0;
}
