/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <linux/spinlock.h>

#include "../me8100.h"

int main(void){
  int err = 0;
  int minor = 0;
  int count = 0;
  int i;
  static int file_handle = -1;

  unsigned short ctrl_a;
  unsigned short ctrl_b;
  unsigned short value_a;
  unsigned short value_b;

  printf("%c%3s", 27, "[2J");
  printf("<<<--- ME8100 TESTPROGRAM FOR DIO --->>>\n\n");

  /*
   * You can select up to four me8100 baords, if installed.
   * 0 is the first board.
   */
  printf("Please type in the Minor Device Number of Board to open : ");
  count = scanf("%d", &minor);
  if(!count){
    printf("Invalid Input !\n");
    return 1;
  }
  printf("Open path /dev/me8100_%d !\n\n", minor);
  
  switch(minor){
  case 0:
    file_handle = open("/dev/me8100_0", O_RDWR, 0);
    break;
  case 1:
    file_handle = open("/dev/me8100_1", O_RDWR, 0);
    break;
  case 2:
    file_handle = open("/dev/me8100_2", O_RDWR, 0);
    break;
  case 3:
    file_handle = open("/dev/me8100_3", O_RDWR, 0);
    break;
  default:
    printf("Invalid Input !\n");
    return 1;
  }

  if(file_handle < 0){
    printf("Cannot open path !\n");
    return 1;
  }

  /*
   * DIGITAL I/O 
   *
   * Now that you have access to the me8100 have to configurate
   * the board according to your needs. 
   * The ME8100_B has got two output ports with 16 bit each. You can
   * decide wether the port is driven as sink or as source.
   * Additionally, you have to enable the outputs explicitly.
   */


  /*------------------ BOTH OUTPUT PORTS AS SOURCE --------------------------*/

  printf("\nPlease press return to test both output ports as source :\n");
  getchar();
  getchar();
  
  /* Setup for the first output port */
  ctrl_a = 0x90; /* We want to configure as source and to enable the outputs */
  err = ioctl(file_handle , ME8100_WRITE_CTRL_A, &ctrl_a);
  if(err){
    printf("Cannot setup output port A \n");
    return 1;
  }

  /* Setup for the second output port */
  ctrl_b = 0x90; /* We want to configure as source and to enable the outputs */
  err = ioctl(file_handle , ME8100_WRITE_CTRL_B, &ctrl_b);
  if(err){
    printf("Cannot setup output port B \n");
    return 1;
  }

  for(i = 0; i < 16; i++){
    /* Write to port A */
    value_a = 0x1 << i;
    err = ioctl(file_handle, ME8100_WRITE_DO_A, &value_a); /* Do the job */
    if(err){
      printf("Cannot write to output port A \n");
      return 1;
    }
    printf("Write to Port A : 0x%04X\n", value_a);
    
    /* Write to port B */
    value_b = 0x8000 >> i;
    err = ioctl(file_handle, ME8100_WRITE_DO_B, &value_b); /* Do the job */
    if(err){
      printf("Cannot write to port B \n");
      return 1;
    }
    printf("Write to Port B : 0x%04X\n\n", value_b);
    sleep(1);
  }


  /*-------------------- BOTH OUTPUT PORTS AS SINK --------------------------*/

  printf("Please press return to test both output ports as sink :\n");
  getchar();
  
  /* Setup for the first output port */
  ctrl_a = 0x80; /* We want to configure as sink and to enable the outputs */
  err = ioctl(file_handle , ME8100_WRITE_CTRL_A, &ctrl_a);
  if(err){
    printf("Cannot setup output port A \n");
    return 1;
  }

  /* Setup for the second output port */
  ctrl_b = 0x80; /* We want to configure as sink and to enable the outputs */
  err = ioctl(file_handle , ME8100_WRITE_CTRL_B, &ctrl_b);
  if(err){
    printf("Cannot setup output port B \n");
    return 1;
  }

  for(i = 0; i < 16; i++){
    /* Write to port A */
    value_a = 0x1 << i;
    err = ioctl(file_handle, ME8100_WRITE_DO_A, &value_a); /* Do the job */
    if(err){
      printf("Cannot write to output port A \n");
      return 1;
    }
    printf("Write to Port A : 0x%04X\n", value_a);
    
    /* Write to port B */
    value_b = 0x8000 >> i;
    err = ioctl(file_handle, ME8100_WRITE_DO_B, &value_b); /* Do the job */
    if(err){
      printf("Cannot write to port B \n");
      return 1;
    }
    printf("Write to Port B : 0x%04X\n\n", value_b);
    sleep(1);
  }

  /*--------------------------- READ FROM BOTH INPUT PORTS -----------------------*/

  printf("Please press return to read from both input ports :\n");
  getchar();

  for(i = 0; i < 20; i++){
    /* Read from port A */
    err = ioctl(file_handle, ME8100_READ_DI_A, &value_a);  /* Do the job */
    if(err){
      printf("Cannot read port A \n");
      return 1;
    }
    /* 
     * The result is put into value_a. 
     * We simply print the result as a hex number. 
     */
    printf("Read from Port A: 0x%04X\n", value_a);
    
    
    /* Read from port B */
    err = ioctl(file_handle, ME8100_READ_DI_B, &value_b);  /* Do the job */
    if(err){
      printf("Cannot read port B \n");
      return 1;
    }
    /* 
     * The result is put into value_b. 
     * We simply print the result as a hex number. 
     */
    printf("Read from Port B: 0x%04X\n\n", value_b);
    sleep(1);
  }


  /*-------------------------------- END ------------------------------------*/

  printf("Close path to me8100_%d\n", minor);
  err = close(file_handle);
  if(err){
    printf("Kann Pfad nicht schliessen\n");
    return 1;
  }

  return 0;
}
