package ME8100;

# (c) 2002 Heiko Schlittermann

use strict;
use Fcntl;
use IO::File;
use IO::Select;
use Carp;

my %Objects = ();

if (defined $SIG{IO}) {
    die "SIG IO is already defined.  Since we won't disturb your application\n"
      . "we decied to refuse loading this module.  Sorry\n";
}

# If an interrupt occurs, we've to search for the file descriptor(s)
# that caused the interrupt.  This is done by a lookup in the module global
# %Objects hash.  ("fd" -> { fd => XXX, object => XXXX })

$SIG{IO} = sub { 
    my $val;
    warn "Got signal $_[0]\n";

    # I do some magic(?) here, since the key isn't usable a a refence
    # anymore, we stored the reference itself behind the key, as well
    # as the object reference...
    

    # Now a race condition might occur.  It's possible that an other
    # select() runs too (called in the read() method).
    my $select = new IO::Select(map { $Objects{$_}->{fd} } keys %Objects);
    my @ready = $select->can_read(0);

    print "May read on fds: @ready\n";

    foreach (@ready) {
	my $object = $Objects{$_}->{object};
	my $fd = $Objects{$_}->{fd};
	$object->_read($fd);
    }

    warn "done signal\n";

};

# Create a new object. Open all the named devices (read only)
# and read the current values (as the driver guarantees the
# very first read to succeed).
# The order depends on the order the device names are passed 
# to the new() method;

sub new {
    my $self = {};
    my $class = shift;
    bless $self, $class;

    my (@fds, @inputs);
    my %idx = ();
    my $idx = 0;
    foreach my $device (@_) {
	my ($flags, $val);
	my $fd = new IO::File($device, "r")
	    or croak("open($device): $!\n");

	fcntl($fd, F_SETOWN, $$) or croak "Can't set owner: $!\n";
	$flags = fcntl($fd, F_GETFL, 0) or croak "Can't get flags: $!\n";
	fcntl($fd, F_SETFL, $flags | O_ASYNC) or croak "Can't set flags: $!\n";

	$fd->sysread($val, 2);

	$Objects{$fd} = { object => $self, fd => $fd };
	$idx{$fd} = $idx;
	push @inputs, $val;
	push @fds, $fd;

	++$idx;
    }

    $self->{idx} = {%idx};	    # fd -> index in input word array
    $self->{fds} = [@fds];	    # list of fds
    $self->{inputs} = [@inputs];    # array of input words
    $self->{select} = new IO::Select(@fds);

    return $self;
}

sub _read {
    my ($self, $fd) = @_;
    my $val;

    my $idx = $self->{idx}->{$fd};
    $self->{fds}->[$idx]->sysread($val, 2) or carp("sysread(): $!\n");
    $self->{inputs}->[$idx] = $val;
}

sub read {
    my ($self, $timeout) = @_;

    local $SIG{IO} = sub { warn "*** SIG $_[0] diverted\n" };
    my @ready = $self->{select}->can_read($timeout);

    if (!@ready) {
	warn "select() returned nothing: $!\n";
	return undef;
    }

    foreach (@ready) {
	$self->_read($_);
    }

    return split //, unpack("b*", join("", @{$self->{inputs}}));
}

sub DESTROY
{
    my $self = shift;
    delete @Objects{ @{$self->{fds}} };
}


1;
# vim:sts=4 sw=4 aw ai sm:
