#! /usr/bin/perl -w

use strict;
use Fcntl;

my $DEV = "/dev/me8100_0a";
my $flags;

$SIG{IO} = sub { 
	my $val;
	sysread(DEV, $val, 2);
	$val = unpack("s", $val);
	print "Hi, got a signal, read $val\n";
	print "<", unpack("b16", pack("N", $val)), ">\n";
};

open(DEV, $DEV)
	or die "Can't open $DEV: $!\n";

fcntl(DEV, F_SETOWN, $$) or die "Can't set owner: $!\n";
$flags = fcntl(DEV, F_GETFL, 0) or die "Can't get flags: $!\n";
fcntl(DEV, F_SETFL, $flags | O_ASYNC) or die "Can't set flags: $!\n";

while(sleep(1000)) {
}
