package ME8100;

# (c) 2002 Heiko Schlittermann

use strict;
use Fcntl;
use IO::File;
use IO::Select;
use Carp;

my %Objects = ();

# If an interrupt occurs, we've to search for the file descriptor(s)
# that caused the interrupt.  The file descriptor(s) should in turn
# point us the the proper me8100 object ...
#
$SIG{IO} = sub { 
    my $val;
    warn "Got signal $_[0]\n";

    my $select = new IO::Select(map { $Objects{$_}->{fd} } keys %Objects);
    my @ready = $select->can_read(0);

    foreach my $fd (@ready) {
	my $current = $Objects{$fd};
	my $idx = $current->{idx};
	my $object = $current->{object};

	#$object->_read($fd);

	warn "read ", $fd->fileno(), "\n";

	my $val;
	$fd->sysread($val, 2) or carp("sysread(): $!\n");
	$object->{inputs}->[$idx] = $val;
	$object->{changed} = 1;
    }

    #kill("ALRM", $$);
    warn "done signal\n";

};

sub _read {
    my $self = shift;
    my $fd = shift;
    warn "read from ", $fd->fileno(), "\n";
}



# Create a new object. Open all the named devices (read only)
# and read the current values (as the driver guarantees the
# very first read to succeed).
# The order depends on the order the device names are passed 
# to the new() method;

sub new {
    my $self = {};
    my $class = shift;
    bless $self, $class;

    my (@fds, @inputs);
    my $idx = 0;
    foreach my $device (@_) {
	my ($flags, $val);
	my $fd = new IO::File($device, "r")
	    or croak("open($device): $!\n");

	fcntl($fd, F_SETOWN, $$) or croak "Can't set owner: $!\n";
	$flags = fcntl($fd, F_GETFL, 0) or croak "Can't get flags: $!\n";
	fcntl($fd, F_SETFL, $flags | O_ASYNC) or croak "Can't set flags: $!\n";

	$Objects{$fd} = { fd => $fd, idx => $idx, object => $self };
	$fd->sysread($val, 2);

	push @inputs, $val;
	push @fds, $fd;

	++$idx;
    }

    $self->{fds} = [@fds];
    $self->{inputs} = [@inputs];
    $self->{select} = new IO::Select(@fds);
    $self->{changed} = 1;

    return $self;
}

sub read {
    my $self = shift;
    my $timeout = shift;

    return split //, unpack("b*", join("", @{$self->{inputs}}));
}

sub changed {
    my $self;
    return $self->{changed};
}

sub DESTROY
{
    my $self = shift;
    delete @Objects{ @{$self->{fds}} };
}


1;
# vim:sts=4 sw=4 aw ai sm:
