/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <stdlib.h>
#include "me8100.h"

#define USE_WRITE

const char* DEVICE = "/dev/me8100_0a";

int main(int argc, char** argv) {
  int err = 0;
  static int file_handle = -1;

#ifndef USE_WRITE
  unsigned short ctrl_a;
#endif
  unsigned short value_a;

  if (argc > 1) DEVICE = argv[1];
  printf("Write test, to %s PID: %d\n", DEVICE, getpid());
#ifdef USE_WRITE
  printf("Using write()\n");
#endif


  if (-1 == (file_handle = open(DEVICE, O_WRONLY, 0))) {
    fprintf(stderr, "Can't open %s: %m\n", DEVICE);
    exit(EXIT_FAILURE);
  }

#ifndef USE_WRITE
  ctrl_a = ME8100_CTRL_ENIO | ME8100_CTRL_SOURCE | ME8100_CTRL_IRQ_MASK;
  err = ioctl(file_handle, ME8100_WRITE_CTRL_A, &ctrl_a);
  if (err) {
    fprintf(stderr, "Can't setup output to port A\n");
    return 1;
  }
#endif

  value_a = 0xffff;
  write(file_handle, &value_a, sizeof(value_a));
  exit(EXIT_SUCCESS);

  for (value_a = 0x01; value_a < 0xffff; ++value_a) {
#ifdef USE_WRITE
    write(file_handle, &value_a, sizeof(value_a));
#else
    ioctl(file_handle, ME8100_WRITE_DO_A, &value_a);
#endif
    printf("Wrote %04x\n", value_a);
    sleep(1);
  }

  err = close(file_handle);
  if(err){
    printf("Kann Pfad nicht schliessen\n");
    return 1;
  }

  return 0;
}
/*
	vim:sts=2 sw=2 aw ai sm:
*/
