/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "me8100.h"

#define USE_READ

int main(void){
  int err = 0;
  static int file_handle = -1;

  unsigned short value_a;

  printf("Read test, PID: %d\n", getpid());
#ifdef USE_READ
  printf("Using read()\n");
#endif
  file_handle = open("/dev/me8100_0a", O_RDONLY, 0);

  if(file_handle < 0){
    printf("Cannot open path !\n");
    return 1;
  }

  for (;;sleep(1)) {
#ifdef USE_READ
    int n;
    n =read(file_handle, &value_a, sizeof(value_a));
    if (n == 0) {
      fprintf(stderr, "read 0 bytes\n");
      continue;
    } 
    if (n < 0) {
      fprintf(stderr, "read 0 bytes: %m\n");
      continue;
    }
#else
    ioctl(file_handle, ME8100_READ_DI_A, &value_a);
#endif
    printf("Read  %04x\n", value_a);
  }

  err = close(file_handle);
  if(err){
    printf("Kann Pfad nicht schliessen\n");
    return 1;
  }

  return 0;
}
/*
	vim:sts=2 sw=2 aw ai sm:
*/
