/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <stdlib.h>
#include "me8100.h"

#define USE_READ

const char* DEVICE = "/dev/me8100_0a";

int main(int argc, char** argv) {
  static int file_handle;
  unsigned short value_a;

  if (argc > 1) DEVICE = argv[1];

  printf("Read test, from %s, PID: %d\n", DEVICE, getpid());
#ifdef USE_READ
  printf("Using read()\n");
#endif

  if (-1 == (file_handle = open(DEVICE, O_RDONLY, 0))) {
    fprintf(stderr, "Can't open %s: %m\n", DEVICE);
    exit(EXIT_FAILURE);
  }

  for (;;sleep(1)) {
#ifdef USE_READ
    int n;
    n =read(file_handle, &value_a, sizeof(value_a));
    if (n == 0) {
      fprintf(stderr, "read 0 bytes\n");
      continue;
    } 
    if (n < 0) {
      fprintf(stderr, "read 0 bytes: %m\n");
      continue;
    }
#else
    ioctl(file_handle, ME8100_READ_DI_A, &value_a);
#endif
    printf("Read  %04x\n", value_a);
  }

  if(0 != close(file_handle)) {
    perror("Can't close device");
    exit(EXIT_FAILURE);
  }

  return 0;
}
/*
	vim:sts=2 sw=2 aw ai sm:
*/
