#! /usr/bin/perl -w

use ME8100 qw/:async/;

my @DEVICES = qw(/dev/me8100_0a /dev/me8100_0b);
my @INPUTS = qw(Tr1 Tr2 Feuerlscher);

sub _sleep($);


MAIN: {
    my $me8100 = new ME8100(@DEVICES);
    my (%inputs, %changed);

    # first read will be always go through
    @inputs{@INPUTS} = $me8100->read();

    print "Read:\n";
    print map { sprintf "%20s: %d\n", $_, $inputs{$_} } @INPUTS;

    _sleep(10);		   
			  
    @inputs{@INPUTS} = $me8100->status();
    print "Status2:\n";
    print map { sprintf "%20s: %d\n", $_, $inputs{$_} } @INPUTS;

    @inputs{@INPUTS} = $me8100->changed();
    print "Changed:\n";
    print map { sprintf "%20s: %d\n", $_, $inputs{$_} } @INPUTS;

    # and now block 'til the next change...
    @inputs{@INPUTS} = $me8100->read();
    @changed{@INPUTS} = $me8100->changed();
    print "Finally:\n";
    print map { sprintf "%20s: %d (%d)\n", $_, $inputs{$_}, $changed{$_} } @INPUTS;

}

# Sleep replacement, since the standard sleep 
# gets awoken on every signal
sub _sleep($) {
    my $timeout = shift;
    while ($timeout > 0) {
	$timeout -= sleep($timeout);
    }
}

# vim:sts=4 sw=4 aw ai sm:
