/*
 * Source File : me8100_test_dio.c
 * Destination : me8100_test_dio
 * Author      : GG (Guenter Gebhardt)                                 
 *    
 *                                                                     
 * File History: Version   Date       Editor   Action                  
 *---------------------------------------------------------------------
 *               1.00.00   01.07.12   GG       first release           
 *                                                                     
 *---------------------------------------------------------------------
 *                                                                     
 * Description:
 *   This program shows the use of the driver and the digital inputs
 *   and outputs. First the outputs are tested in sink and source mode. 
 *   Then the inputs are tested.
 */
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include "me8100.h"

#define USE_WRITE

const char* DEVICE = "/dev/me8100_0a";

int main(int argc, char** argv) {
  char dev = 0;
  static int file_handle;
  unsigned short value;

  if (argc > 1) DEVICE = argv[1];
  dev = DEVICE[strlen(DEVICE) - 1];

  printf("Write test, to %s PID: %d\n", DEVICE, getpid());
  printf("Using write()\n");



  if (-1 == (file_handle = open(DEVICE, O_WRONLY, 0))) {
    fprintf(stderr, "Can't open %s: %m\n", DEVICE);
    exit(EXIT_FAILURE);
  }

  for (value = 0x00;;++value) {
    int val;
    if (value > 0xff) value = 0;

    val = value + (dev << 8);;
    write(file_handle, &val, sizeof(val));
    printf("Wrote %04x\n", val);
    sleep(1);
  }

  if(-1 == close(file_handle)) {
    perror("Can't close file");
    exit(EXIT_FAILURE);
  }

  return 0;
}
/*
	vim:sts=2 sw=2 aw ai sm:
*/
