package Fops::native;
use 5.010;
use strict;
use warnings;
use Carp;
use Cwd qw(abs_path cwd);
use base qw(Fops);
use File::Path ();
use Fops qw(_path);

our $VERSION = "0.0";

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = bless {
        type => "native",
        root => shift,
        cwd  => "/",
    } => $class;
    return $self;
}

sub cd {
    my $self = shift;
    my $dst  = shift;

    $dst = $self->{cwd} .= "/$dst"
      if $dst !~ /^\//;

    $self->{cwd} = _path($dst);
}

sub stat {
    my $self = shift;
    stat(_path($self->{root}, shift));
}

sub is_dir {
    my $self = shift;
    -d _path($self->{root}, shift);
}

sub is_file {
    my $self = shift;
    -f _path($self->{root}, shift);
}

sub mkpath {
    my $self = shift;
    File::Path::mkpath([ map { _path($self->{root}, $_) } @_ ]);
}

1;
