package Fops::native;
use 5.010;
use strict;
use warnings;
use Carp;
use Cwd qw(abs_path cwd);
use base qw(Fops);

our $VERSION = "0.0";

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = bless {
        type => "native",
        root => shift,
        cwd  => "/",
    } => $class;
    return $self;
}

sub cd {
    my $self = shift;
    my $dst  = shift;

    $dst = $self->{cwd} .= "/$dst"
      if $dst !~ /^\//;

    my @path;
    my @parts = grep {length} split /\// => $dst;
    while (@parts) {
        my $_;
        given ($_ = pop @parts) {
            when (".")  { }
            when ("..") { pop @parts }
            default { unshift @path => $_ }
        }
    }

    #$self->{cwd} =~ s{/\.(?=/|$)}{}g;	# dots
    #$self->{cwd} =~ s{/[^/]+/\.\.(?=/|$)}{}g;
    #$self->{cwd} =~ s{/+}{/}g;

    $self->{cwd} = "/" . join "/" => @path;

    $self;
}

1;
