package Fops;
use strict;
use warnings;
use Carp;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $implementation = shift;
    eval "require Fops::$implementation";
    return "Fops::$implementation"->new(@_);
}

sub type { shift->{type} }

sub cd {
    my $self = shift;
    croak "method `cd' needs implementation in ".ref $self;
}


1
__END__

=head1 NAME
    
    Fops - file operations

=head1 SYNOPSIS

    use Fops;

    $fops = Fops->new(native => $root);

    $fops->cd("dir");
    $fops->put($src => $dst);
    $fops->rename($from => $to);
    $fops->stat($src);
    $fops->get($src => $dst);

    $src = $fops->get($src);

=head1 DESCRIPTION

A simple abstraction for some file operations.
To be of real use, this module needs helpers.

=head1 SEE ALSO

L<Fops::native(3)>

=cut
