package Fops::native;
use strict;
use warnings;
use Carp;
use Cwd ();
use base qw(Fops);

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = bless {} => $class;
    $self->{root} = shift;
    $self->{type} = "native";

    return $self;
}

sub cd {
    my $self = shift;
    my $dst = shift;

    if ($dst =~ /\//) {
	$dst = Cwd::abs_path "$self->{root}/$dst";
    }
    else {
	$dst = Cwd::abs_path(cwd . "/$dst");
    }

    croak "invalid destination $dst" 
	if not $dst =~ /^$self->{root\/}/;

    chdir $dst or croak "Can't chdir to $dst: $!";
}

sub pwd { cwd }


1;
