package Fops;
use 5.010;
use strict;
use warnings;
use Carp;
use base qw(Exporter);
our @EXPORT_OK = qw(_path);

our $VERSION = "0.1";

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $implementation = shift;
    eval "require Fops::$implementation"
      or die $@;

    #"Fops::$implementation"->import("0.1");
    return "Fops::$implementation"->new(@_);
}

sub type { shift->{type} }
sub pwd  { shift->{cwd} }
sub root { shift->{root} }

sub cd {
    my $self = shift;
    croak "method `cd' needs implementation in " . ref $self;
}

sub stat {
    my $self = shift;
    croak "method `stat` needs implementation in " . ref $self;
}

sub _path {
    my @parts = grep {length} split /\// => join "/", @_;
    my @path;

    while (@parts) {
        my $_;
        given ($_ = pop @parts) {
            when (".")  { }
            when ("..") { pop @parts }
            default { unshift @path => $_ }
        }
    }

    #$self->{cwd} =~ s{/\.(?=/|$)}{}g;	# dots
    #$self->{cwd} =~ s{/[^/]+/\.\.(?=/|$)}{}g;
    #$self->{cwd} =~ s{/+}{/}g;

    return "/" . join "/" => @path;
}

1
__END__

=head1 NAME
    
    Fops - file operations

=head1 SYNOPSIS

    use Fops;

    $fops = Fops->new(native => $root);

    $fops->cd("dir");
    $fops->put($src => $dst);
    $fops->rename($from => $to);
    $fops->stat($src);
    $fops->get($src => $dst);

    $src = $fops->get($src);

=head1 DESCRIPTION

A simple abstraction for some file operations.
To be of real use, this module needs helpers.

=head1 SEE ALSO

L<Fops::native(3)>

=cut
