package BlockDev;

use 5.010;
use strict;
use warnings;
use Attribute::Params::Validate qw(:all);

our $VERSION = "0.0";

my %X;

sub list {
    open(my $fh => "/proc/partitions");
    return map { (split)[3] } grep /^\s*\d+/ => <$fh>;
}

sub new : Validate(uuid => 0, dev => 0) : method {
    my $class = shift;
    my $self = bless \my $x => $class;
    my %arg = @_;
    $X{$self} = \%arg;

    if ($arg{dev}) {
	die "ERROR device `$arg{dev}': $!\n"
	    if not -b $arg{dev};
	$self->_rdev_by_dev;
    }

    return $self;
}

sub major { return $X{+shift}{major} }
sub minor { return $X{+shift}{minor} }

sub _rdev_by_dev {
    my $self = shift;
    $X{$self}{major} = (stat $X{$self}{dev})[6] >> 8;
    $X{$self}{minor} = (stat _)[6] & 0xFF;
}

sub rdev {
    my $self = shift;
    return $self->major, $self->minor if wantarray;
    return join " " => $self->major, $self->minor;
}

sub dev {
    my $self = shift;
    return $X{$self}{dev} if exists $X{$self}{dev};
}

sub DESTROY {
    my $self = shift;
    delete $X{$self};
}

1;

__END__

=head1 NAME

    BlockDev - library for doing various things on block devices

=head1 SYNOPSIS

    use BlockDev;

    @devices = BlockDev->list();

    $device = BlockDev->new(uuid => "02323-232-22...");
    $device = BlockDev->new(dev => "/dev/sda1");

    ($major, $minor) = $device->rdev;

=head1 Static methods

=over

=item list()

Lists all known block devices (basically listing of F</proc/partitions>)

=item new()

Create a new blockdev object. I<$>

=back

    
