package SI::system;

use strict;
use warnings;
use File::Temp qw(tempdir);
use if $ENV{DEBUG} ~~ qw(system) => "Smart::Comments";
use SI::tools;

$ENV{LC_ALL} = "C";

sub id() {
    # hope it's eth* or wlan*
    local $_ = (sort grep { /^(eth|wlan)/ } `ifconfig -a`)[0];
    /^(?<dev>\S+)\s.*HWaddr\s+(?<mac>[\da-f:]+)\s*$/i
    	and return $+{mac};
    die "ERR: Can't get system identification (MAC address)\n";
}

sub hostname(\%) {
	my $devs = shift;
	my $mnt = tempdir(CLEANUP => 1);
	my $r;

	foreach my $fs (grep { $devs->{volume}{$_}{type} =~ /^ext/i } 
		grep { exists $devs->{volume}{$_}{type} }
		keys %{$devs->{volume}}) {
		run("mount -r $fs $mnt");
		if (-f "$mnt/etc/hostname") {
			die "ERR: found 2nd hostname" if defined $r;
			chomp($r = cat("$mnt/etc/hostname"));
		}
		run("umount $mnt");
	}

	return $r;
}

1;
# vim:sts=4 sw=4 aw ai si:
