package SI::mbr;

use strict;
use warnings;
use File::Basename;
use IO::File;
use if $ENV{DEBUG} ~~ q(mbr) => "Smart::Comments";

use SI::tools;

sub save($\%) {
	my ($file, $devs) = @_;
	

	foreach my $disk (keys %{$devs->{disk}}) {
		verbose("saving mbr of $disk\n");
		open((my $o), $_ = sprintf(">$file", basename($disk))) or die "Can't open $_: $!\n";

		local $/ = \512;
		my $in = new IO::File $disk or die "Can't open $disk: $!\n";
		print $o $_ = <$in>;
	}
}

1;
