package SI::blkid;

use if $ENV{DEBUG} ~~ /blkid|all/ => "Smart::Comments";

use strict;
use warnings;
use IO::File;
use File::Basename;

use SI::tools;

sub ids($\%) {
    my ($file, $devs) = @_;

    my @volumes = sort keys %{ $devs->{volume} };
    verbose("reading blkids: @volumes");
    foreach (`blkid -c /dev/null @volumes`) {
        my $dev = (split /:/)[0];

        my ($uuid)  = /\sUUID=.(.*?).\s/;
        my ($type)  = /\sTYPE=.(.*?).\s/;
        my ($label) = /\sLABEL=.(.*?).\s/;

        if (exists $devs->{volume}{$dev}) {
            $devs->{volume}{$dev}{uuid}  = $uuid;
            $devs->{volume}{$dev}{type}  = $type;
            $devs->{volume}{$dev}{label} = $label;

            my ($of, $oh);
            if (defined $uuid) {
                $of = sprintf $file, "uuid." . basename $dev;
                $oh = new IO::File ">$of" or die "ERR: Can't open $of: $!\n";
                $oh->print("$uuid\n");
            }

            if (defined $label) {
                $of = sprintf $file, "label." . basename $dev;
                $oh = new IO::File ">$of" or die "ERR: Can't open $of: $!\n";
                $oh->print("$label\n");
            }

            if (defined $type) {
                $of = sprintf $file, "type." . basename $dev;
                $oh = new IO::File ">$of" or die "ERR: Can't open $of: $!\n";
                $oh->print("$type\n");
            }

        }

    }
    verbose("\n");
}

1;

# vim:sts=4 sw=4 aw ai si:
