package SI::dumper;

use if $ENV{DEBUG} ~~ /dumper|all/ => "Smart::Comments";
use strict;
use warnings;
use SI::tools;
use File::Basename;

sub dump($\%) {
    my ($file, $devs) = @_;
    my $dumpdates = dirname($file) . "/dumpdates";

    foreach my $volume (
        map { { name => $_, %{ $devs->{volume}{$_} } } }
        keys %{ $devs->{volume} }
      )
    {
        next if !defined $volume->{type} or $volume->{type} !~ /^ext/i;

        verbose("dumping volume $volume->{name}");
        my $dumpdev = $volume->{name};
        my $of = sprintf $file, basename($volume->{name});
        run("dump -D $dumpdates -u -0 -z -f $of $dumpdev");
        verbose("\n");
    }
}

1;

# vim:sts=4 sw=4 aw ai sm:
