package SI::ptable;

use strict;
use warnings;
use if $ENV{DEBUG} ~~ "ptable" => "Smart::Comments";
use File::Find;

$ENV{LC_ALL} = "C";

use SI::tools;

sub info($\%) {
	my ($file, $part) = @_;

	# find major of devmapper
	my $devmapper = 0;
	{
	local $/ = undef;
	open(my($i), "/proc/devices") or die "ERR: Can't open /proc/devices: $!\n";
	($devmapper) =  <$i> =~ /^\s*(\d+)\s+device.mapper\b/m;
	}

	my ($current, %dev);
	foreach (`sfdisk -d 2>/dev/null`) {
		chomp;
		### $_
		if (/^# partition table .*?(\/\S+)/) {
			$current = (stat $1)[6] >> 8 == $devmapper ? undef : $1
				and push(@{$dev{$current}}, $_);
			next;
		}
		next if not $current;
		push @{$dev{$current}}, $_;
	}
	### partiton tables of useful blockdevices:
	### %dev

	# process the partition tables
	# and output the tables for relevant devices
	foreach my $dev (keys %dev) {
		($_ = $dev) =~ s/^.*\///;
		my $file = sprintf $file, $_;
		die "ERR: $file exists already\n" if -f $file;
		open(my $o, ">$file") or die "ERR: Can't open $file: $!\n";
		print $o join "\n", @{$dev{$dev}}, "";
	}

	# reserve entries in %part, one for each partition
	@{$part->{physical}}{map { (split)[0] } grep { /^\// } map { @$_ } values %dev} = ();
}
1;
