package SI::lvm;

use strict;
use warnings;
use SI::tools;

sub vg_info($\%) {
	my ($file, $part) = @_;
	foreach (map { (split /:/)[0] } map { /^\s*(.*)/; } `vgs --noheadings --separator :`) {
		my $file = sprintf $file, $_;
		run("vgcfgbackup -f $file >/dev/null");
	}
}

sub lv_info($\%) {
	my ($file, $part) = @_;

	foreach my $p (keys %$part) {
	`pvs -o +uuid --nameprefix --noheadings $p` =~ /\bLVM2_PV_UUID='(.*?)'/
		or next;

	$part->{$p}{type} = "pv";
	$part->{$p}{uuid} = $1;

	}

}

1;
