package SI::blkid;

use strict;
use warnings;
use File::Find;

sub ff($$) {
	my ($dir, $id) = @_;
	my $found;
	find(sub { 
		return if $found;
		$found = (stat)[6] == $id ? $File::Find::name : undef;
		return;
		}, $dir);
	return $found;
}

sub info($\%) {
	my ($file, $part) = @_;

	foreach (`blkid -c /dev/null`) {
		my ($dev) = (split /:/)[0];

		my ($uuid) = /\sUUID=.(.*?).\s/;
		my ($type) = /\sTYPE=.(.*?).\s/;
		my ($label) = /\sLABEL=.(.*?).\s/;

		if ($dev ~~ $part->{physical}) {
			$part->{physical}{$dev}{uuid} = $uuid;
			$part->{physical}{$dev}{type} = $type;
			$part->{physical}{$dev}{label} = $label;
			next;
		}
	
		# dev mapper names should be replace by nicer ones
		if ($dev ~~ /^\/dev\/dm-/) {
			$dev = ff("/dev/mapper", (stat $dev)[6])
				or next;
			$part->{logical}{$dev}{uuid} = $uuid;
			$part->{logical}{$dev}{type} = $type;
			$part->{logical}{$dev}{label} = $label;
		}
		
	}
}

1;
