package SI::mbr;

use strict;
use warnings;
use File::Basename;
use if $ENV{DEBUG} ~~ q(mbr) => "Smart::Comments";

use SI::tools;

sub save($\%) {
	my ($file, $devs) = @_;
	

	foreach my $disk (keys %{$devs->{disks}}) {
		verbose("saving mbr of $disk\n");
		open((my $o), $_ = sprintf(">$file", basename($disk))) or die "Can't open $_: $!\n";
		local $/ = \512;

		open(my $in, $disk) or die "Can't open $disk: $!\n";
		print $o $_ = <$in>;
	}
}

1;
