package SI::tools;

use strict;
use warnings;
use base "Exporter";
our @EXPORT = qw(&run &verbose);
use if $ENV{DEBUG} ~~ /tools|all/ => "Smart::Comments";

sub run(@) {
	system(@_);
	die "$_[0] failed with exit code " . $? >> 8 . "\n"
	if $?;
}

my $last = "\n";
sub verbose(@) { 
    print $last eq "\n" ? "" : " "
	if not(@_ == 1 and length($_[0]) == 1);
    print @_;
    $last = substr($_[-1], -1, 1);
};

1;
# vim:sts=4 sw=4 aw ai si:
