package SI::ptable;

use strict;
use warnings;
use File::Find;
use IO::File;

use if $ENV{DEBUG} ~~ /ptable|all/ => qw(Smart::Comments);

use SI::tools;
$ENV{LC_ALL} = "C";

sub volumes($\%) {
    my ($file, $devs) = @_;

    # find the non-removable devices
    my ($current, $of);
    foreach (`sfdisk -d 2>/dev/null`) {
        chomp;
        if (/^# partition table .*?(\/\S+\/(\S+))/) {
	    # skip the removable devices
	    my ($device, $name) = ($1, $2);
	    verbose("device $device");
	    if ((grep { /ATTR{removable}/ } `udevadm info --attribute-walk --name $name`)[0] !~ /==.0./) {
		    $current = undef;
		    verbose("skipping (removable)\n");
		    next;
	    }

	    # save in our data structure
	    verbose("scanning\n");
	    $current = $device;
	    push @{$devs->{disk}{$current}{pt}}, $_;

	    # and open the outfile
	    my $f = sprintf ">$file", $name;
	    $of = new IO::File $f or die "ERR: Can't open $f: $!\n";
	    print $of "$_\n";

	    next;
        }
        next if not $current;
	push @{$devs->{disk}{$current}{pt}}, $_;
	print $of "$_\n";

	if (/^(\/dev\/\S+)\s*:/) {
	    $devs->{volume}{$1} = undef;
	}

    }

### $devs
    return;
}
1;
# vim:sts=4 sw=4 aw ai si:
