package SI::lvm;

use strict;
use warnings;
use IO::File;

use if $ENV{DEBUG} ~~ /lvm|all/ => qw(Smart::Comments);

use SI::tools;

my @volumegroups = ();

sub _vgs(\%) {
    return @volumegroups if @volumegroups;

    my $devs = shift;

    my @pvs = grep { $devs->{volume}{$_}{type} =~ /^lvm/ } 
	grep { defined $devs->{volume}{$_} }
	keys %{$devs->{volume}};

    return @volumegroups = map { (split /:/)[1] } `pvdisplay -c @pvs`;
}

sub volumes(\%) {
    my ($devs) = @_;

    # we can't just use `pvs', since this would return *all*
    # physical devices known to lvm, not just the non-removable
    my @pvs = grep { $devs->{volume}{$_}{type} =~ /^lvm/ } 
	grep { defined $devs->{volume}{$_} }
	keys %{$devs->{volume}};

    my @vgs = _vgs(%$devs);
    my @lvs = map { readlink } 
	      map { s/^\s*//; (split /:/)[0] } 
	      grep { (split /:/)[1] ~~ @vgs } `lvdisplay -c`;

    @{$devs->{volume}}{@lvs} = ();


}

sub vgcfgbackup($\%) {
    my ($file, $devs) = @_;

    # we save it vg by vg to have the restore more easy
    my @vgs = _vgs(%$devs);
    foreach ( map { s/^\s*(.*)/$1/; $_ = (split /:/)[0] } `vgs --noheadings --separator : @vgs`)
    {
	verbose("saving vg $_\n");
        my $file = sprintf $file, $_;
        run("vgcfgbackup -f $file $_ >/dev/null");
    }

    # for testing let's save it all
    verbose("saving vg *\n");
    $file = sprintf $file, "*";
    run("vgcfgbackup -f '$file' >/dev/null");
}

1;
# vim:sts=4 sw=4 aw ai si:
