package SI::blkid;

use strict;
use warnings;
use File::Find;


use if $ENV{DEBUG} ~~ /blkid|all/ => "Smart::Comments";

use SI::tools;

sub find_by_devid($$) {
    my ($dir, $id) = @_;
    my $found;
    find(
        sub {
            return if $found;
            $found = (stat)[6] == $id ? $File::Find::name : undef;
            return;
        },
        $dir
    );
    return $found;
}


sub ids($\%) {
    my ($file, $devs) = @_;

    verbose("reading blkids:");
    foreach (`blkid -c /dev/null`) {
        my $dev = (split /:/)[0];
	### $dev
	verbose($dev);

        my ($uuid)  = /\sUUID=.(.*?).\s/;
        my ($type)  = /\sTYPE=.(.*?).\s/;
        my ($label) = /\sLABEL=.(.*?).\s/;

        #if ($dev ~~ $devs->{physical}) {
            #$devs->{physical}{$dev}{uuid}  = $uuid;
            #$devs->{physical}{$dev}{type}  = $type;
            #$devs->{physical}{$dev}{label} = $label;
            #next;
        #}

        # dev mapper names should be replaced by nicer ones
        if ($dev ~~ /^\/dev\/dm-/) {
            $dev = find_by_devid("/dev/mapper", (stat $dev)[6]);
	};

	if (exists $devs->{volume}{$dev}) {
            $devs->{volume}{$dev}{uuid}  = $uuid;
            $devs->{volume}{$dev}{type}  = $type;
            $devs->{volume}{$dev}{label} = $label;
	}

    }
    verbose("\n");
}

1;
# vim:sts=4 sw=4 aw ai si:
