package Nagios::Check::DNS::check_tlsa_record;

use strict;
use warnings;
use feature qw(say switch);
use if $ENV{DEBUG} => 'Smart::Comments';
use Carp;

#use if $^V >= v5.0.20 => (experimental => gw(smartmatch));
use experimental qw(smartmatch);
use File::Temp;

our $VERSION = '0.1';

#@TODO use only fh of tempfile instead of filename
my $tempfile = File::Temp->new(
    TEMPLATE => '._tlsaXXXX',
    DIR      => '/tmp/',
    SUFFIX   => '.tmp',
);

sub main {
    my $domain   = shift;
    my $port     = shift || 443;
    my $protocol = shift || 'tcp';
    my $validate = validate_tlsa($domain, $port, $protocol);
    return $validate;
}

sub dig_tlsa {
  #@TODO
  #dig tlsa _443._tcp.torproject.org +short
  #wildcard.torproject.org.
  #3 1 1 578582E6B4569A4627AEF5DFE876EEC0539388E605DB170217838B10 D2A58DA5
  # until it's fixed test 7 returns ok on test on crit tlsa status
    my $domain     = shift;
    my $port       = shift // croak 'Need a port number';
    my $protocol   = shift // 'tcp';
    my $query      = "dig tlsa _$port._$protocol.$domain +short";
    my $dig_return = qx($query);

    if ($dig_return eq '') {
      $dig_return = "No TLSA Record for $domain:$port";
    }
    return $dig_return;
}

sub get_cert {
    my $domain = shift;
    my $port   = shift;
    my $query;
    my $cert;

    if ($port == 25) {
        $query = "openssl s_client -starttls smtp -connect $domain:$port";

    }
    else {
        $query = "openssl s_client -connect $domain:$port";

    }
    my $same = "< /dev/null 2>/dev/null | openssl x509 -out $tempfile 2>&1";
    $query = "$query $same";

    $cert = qx($query);
    return $cert;
}

sub get_tlsa_from_cert {
    my $cert = shift;
    my $hashit = shift || 'sha256';
    my $gentlsa =
        "openssl x509  -in $tempfile -pubkey | "
      . 'openssl rsa -pubin -inform PEM -outform DER 2>/dev/null | '
      . "openssl $hashit";

    my $tlsa_record = qx($gentlsa) or die "nothing found!\n";
    $tlsa_record =~ s/^.*= (.*$)/$1/gi;
    $tlsa_record = uc($tlsa_record);

    return $tlsa_record;
}

sub check_expiry {
    my $cert         = shift;
    my $check_expiry = "openssl x509 -in $cert -noout -startdate -enddate";
    my $expiry       = qx($check_expiry);

    return $expiry;
}

sub get_tlsa_match_type {
    my $dig_return = shift;
    my $tlsa_usage      = substr($dig_return, 0, 1);
    my $tlsa_selector   = substr($dig_return, 2, 1);
    my $tlsa_match_type = substr($dig_return, 4, 1);
    my $hashit;

    for ($tlsa_match_type) {
        when ('0') { die 'certs will be compared directly' }
        when ('1') { $hashit = 'sha256' }
        when ('2') { $hashit = 'sha512' }
        default { $hashit = 'sha256' }
    }
    return $hashit;
}

sub get_dig_tlsa_record {
    my $dig_return = shift;
    my $dig_tlsa = substr($dig_return, 6,);
    $dig_tlsa =~ s/(\S*)\s+(\S*)$/$1$2/;

    return $dig_tlsa;
}

sub get_tlsa_usage {
    my $dig_return = shift;
    my $tlsa_usage = substr($dig_return, 0, 1);

    return $tlsa_usage;
}

sub get_tlsa_selector {
    my $dig_return = shift;
    my $tlsa_selector = substr($dig_return, 2, 1);

    return $tlsa_selector;
}

sub validate_tlsa {
    my $domain     = shift;
    my $port       = shift;
    my $protocol   = shift;
    my $cert       = get_cert($domain, $port);
    my $dig_return = dig_tlsa($domain, $port, $protocol);

    if ($cert =~ /.*unable to load certificate.*/) {
        return "WARNING: No SSL-Certificate for $domain:$port";
    }
    if ($dig_return =~ /no tlsa.*$/gi) {
        return "WARNING: $dig_return";
    }

    my $dig_tlsa   = get_dig_tlsa_record($dig_return);
    my $cert_tlsa  = get_tlsa_from_cert($cert);

    if ("$dig_tlsa" ne "$cert_tlsa") {
        return "CRITICAL: TLSA Record for $domain:$port is not valid";
    }

    return "OK: TLSA Record for $domain:$port is valid";
}

# vim: ft=perl ts=2 sw=2 foldmethod=indent
1;
