
use 5.014;
no strict 'subs';
use Test::More;
use Test::Exception;
use English qw(-no_match_vars);

package FOO;
::require_ok 'blib/nagios/plugins/ius/check_amanda-client';

package main;

subtest 'find_tool' => sub {
    is FOO::find_tool('sh'), '/bin/sh' => 'found /bin/sh';
    dies_ok { FOO: find_tool('abc123xyz-unknown-tool') }
    'dies for unknown tool';
};

subtest 'check_perms' => sub {
    my ($mode, $owner, $group) = (stat $EXECUTABLE_NAME)[2, 4, 5];
    $mode &= 07777;

    ok FOO::check_perms($EXECUTABLE_NAME, $mode, $owner, $group),
      "perms of $EXECUTABLE_NAME 1";
    ok FOO::check_perms(
        $EXECUTABLE_NAME, $mode,
        scalar(getpwuid $owner),
        scalar(getgrgid $group)
      ),
      "perms of $EXECUTABLE_NAME 2";
    dies_ok { FOO::check_perms($EXECUTABLE_NAME, $mode, $owner + 1, $group) }
    'dies on wrong perms';
};

subtest 'config_names' => sub {
    is_deeply [sort +FOO::config_names('t/etc/amanda')],
      [sort qw(foobar DailySet1 WeeklySet1)] => 'got configs';
    dies_ok { FOO::config_names('t/etc/no-amanda') } 'dies on missing configs';
};

subtest 'file systems' => sub {
    my @fs = do {
	local @ARGV = ('/proc/filesystems');
	map { /(\S+)/ } grep { not /^nodev/ } <>;
    };
    my @devs =
      sort { $a->[0] cmp $b->[0] }
      map { [$_->[0], (stat $_->[0])[0]] }
      grep { $_->[1] ~~ @fs }
      map { [(split)[6, 1]] } `df -PT`;
    ok scalar @fs => 'have file systems for testing';
    ok scalar @devs => 'have devices for testing';
    is_deeply [sort { $a->[0] cmp $b->[0] } FOO::get_devices()],
      \@devs => 'got the proper devices';

};

done_testing;
