use Test::More tests => 2;
use strict;
use warnings;
use Fatal qw(:void open seek truncate);
use FindBin qw($Bin);
use File::Temp qw(tempfile);;
use File::Compare;

my $MIMECUT = "$Bin/../hs12";

my $tmpout = tempfile();
open(my $saveout, ">&STDOUT");
open(STDOUT, ">&", $tmpout);

foreach (qw(plain signed)) {
    seek($tmpout, 0, 0);
    truncate($tmpout, 0);

    system("$MIMECUT <$Bin/../messages/$_.in");
    seek($tmpout, 0, 0);
    is(compare($tmpout, "$Bin/../messages/$_.out"), 0, $_);
}


__END__
use Fatal qw(:void open close seek);
use FindBin qw($Bin);

use IO::File;

my $out = new_tmpfile IO::File;
my $err = new_tmpfile IO::File;


my $pid = open(CUTTER, "|-") or do {
	open(STDERR, ">&", $err);
	open(STDOUT, ">&", $out);
	exec "../mimecut";
	die "Can't exec: $!\n";
};

open(X, "$Bin/mail1.eml");

print CUTTER <X>;
close(CUTTER);

seek($out, 0, 0);
print <$out>;
