package Joker;

use 5.010;
use strict;
use warnings;
use Carp;

use Moose;
use MooseX::SemiAffordanceAccessor;
use LWP::UserAgent;

has [qw(username password)] => (
    isa => 'Str',
    is => 'ro',
    required => 1
);

has uri => (
    isa => 'Str',
    is => 'ro',
    default => 'https://dmapi.joker.com/request/',
);

has ua => (
    isa => 'LWP::UserAgent',
    is => 'ro',
    default => sub { LWP::UserAgent->new },
);

has auth_id => (
    isa => 'Str',
    is => 'ro',
    lazy => 1,
    builder => 'login',
);

sub request {
    my ($self, $type) = (shift, shift);
    my %parm = (
	'Auth-Sid', $self->auth_id,
	@_,
    );
    my $req = HTTP::Request->new(
	GET => $self->uri . "$type?" .  join '&', map { "$_=$parm{$_}" } keys %parm);
    my $result = $self->ua->request($req);
    croak $result->status_line if not $result->is_success;
    return $result->content;
}

sub login {
    my $self = shift;
    my $req = HTTP::Request->new(
	GET => $self->uri . 'login?'
	    . 'username=' . $self->username . '&'
	    . 'password=' . $self->password);
    my $result = $self->ua->request($req);

    croak $result->status_line if not $result->is_success;
    return $1 if $result->content =~ /^Auth-Sid:\s+(\S+)/m;

    croak q{Can't get Auth-Sid};
}

1;
