package Joker::Result;
use Moose;
use MooseX::SemiAffordanceAccessor;

has response => (is => 'ro', isa => 'Str');

has fields => (
    is       => 'ro',
    isa	     => 'ArrayRef',
    lazy     => 1,
    init_arg => undef,
    builder  => '_fields'
);

has status => (
    is       => 'ro',
    lazy     => 1,
    init_arg => undef,
    builder => '_status'
);

has data => (
    is => 'ro',
    isa => 'HashRef',
    lazy => 1,
    init_arg => undef,
    builder => '_data',
);

has fields => (
    is => 'ro',
    isa => 'ArrayRef',
    lazy => 1,
    init_arg => undef,
    default => sub { sort keys %{ $_[0]->data } },
);

has code => (
    is => 'ro',
    isa => 'Int',
    lazy => 1,
    init_arg => undef,
    default => sub { $_[0]->data->{'status-code'} },
);

has status => (
    is => 'ro',
    isa => 'Str',
    lazy => 1,
    init_arg => undef,
    default => sub { $_[0]->data->{'status-text'} },
);

sub _data {
    my $self = shift;
    my %_data;
    my $_ = $self->response;
    while (/^(\S+):\s*(.*)$/gm) {
	$_data{lc $1} = $2;
    }
    return \%_data;
}

__PACKAGE__->meta->make_immutable;
