#! /bin/sh
#
# automaticly update logbuch
# if using apt-get or aptitude command
#
# (C) 2011 by Christian Arnold - Schlittermann internet & unix support

set -e

unset  LC_ALL
export LANG=C
export LC_CTYPE=en_US.UTF-8

LOGBUCH_OPTS=""

if test -f /etc/default/ius.upgrade.conf; then
    . /etc/default/ius.upgrade.conf
fi

TMPFILE1=$(tempfile)
TMPFILE2=$(tempfile)
trap "rm -f $TMPFILE1 $TMPFILE2" EXIT

APT_CMD=$(ps -p $1 -o args=)

APT=`echo $APT_CMD | awk '{ print $1 }'`

if [ "$APT" = "aptitude" ]; then
    APT_OPTS="--assume-yes --quiet --verbose --show-versions"
else
    APT_OPTS="--yes"
fi

APT_ARGS=$(echo $APT_CMD | sed "s/$APT[[:space:]]\+//")

# Simulation
$APT --simulate $APT_OPTS $APT_ARGS > $TMPFILE1 2>&1
if tail -1 $TMPFILE1 | grep --quiet --ignore-case abort; then
    exit
fi

grep '^Inst\|Conf\|Remv\|Purg' $TMPFILE1 > $TMPFILE2

logbuch $LOGBUCH_OPTS --message=apt:"$APT_CMD"@$TMPFILE2
