use strict;
use warnings;

use lib 't/lib';
use Aux;

use Test::More;
use File::Temp qw(tempdir);
use Net::LibIDN qw(:all);

# older versions of Test::More (debian lenny fex) don't know done_testing
Test::More->import('no_plan') unless defined &done_testing;

my $zone = "müller.de";
my $CMD = "perl -Mblib blib/sbin/dnssec-keytool";

system("$CMD -h >/dev/null 2>&1");
is($? => 0, "exit on help");

system("$CMD -m >/dev/null 2>&1");
is($? => 0, "exit on man");

system("$CMD >/dev/null 2>&1");
ok($? > 0, "error on missing args");

#$_ = File::Temp::tempdir CLEANUP => 1 or die "Can't make temporary directory" for my ($master_dir, $config_dir);
my $tmp = Aux::make_config;
$ENV{DNSTOOLS_CONF} = $tmp->filename;

system("perl -Mblib blib/sbin/zone-mk xxx $zone >/dev/null 2>&1");
die "zone creation failed" if $?;

system("$CMD --ksk $zone >/dev/null 2>&1");
is($? => 0, 'exit on --ksk');

system("$CMD --zsk $zone >/dev/null 2>&1");
is($? => 0, 'exit on --zsk');

system("$CMD --rm $zone >/dev/null 2>&1");
is($? => 0, 'exit on --rm');

# older versions of Test::More (debian lenny fex) don't know done_testing
if (defined &done_testing) { &done_testing; }
