use strict;
use warnings;

use lib 't/lib';
use Aux;

use Test::More;
use File::Temp qw(tempdir);
use Net::LibIDN qw(:all);

# older versions of Test::More (debian lenny fex) don't know done_testing
Test::More->import('no_plan') unless defined &done_testing;

my $CMD = "perl -Mblib blib/sbin/zone-mk";

system("$CMD -h >/dev/null 2>&1");
is( $? => 0, "exit on help" );

system("$CMD -m >/dev/null 2>&1");
is( $? => 0, "exit on man" );

system("$CMD >/dev/null 2>&1");
ok( $? > 0, "error on missing args" );

$_ = File::Temp::tempdir CLEANUP => 1
  or die "Can't make temporary directory"
  for my ( $master_dir, $config_dir );
my $tmp = Aux::make_config {
    master_dir    => $master_dir,
    zone_conf_dir => $config_dir,
    hostmaster    => 'hostmaster@schlittermann.de',
    template_dir  => './templates'
};
$ENV{DNSTOOLS_CONF} = $tmp->filename;
system("$CMD xxx müller.de >/dev/null 2>&1");
is( $? => 0, "created zone" );

my $domain = idn_to_ascii( "müller.de", "UTF-8" );
ok( -s "$master_dir/$domain/$domain", "zone file $domain" );
ok( -s "$config_dir/$domain",         "config file $domain" );

# older versions of Test::More (debian lenny fex) don't know done_testing
if ( defined &done_testing ) { &done_testing; }
