#! /usr/bin/perl

use strict;
use warnings;
use lib 't/lib';
use Test::More qw(no_plan);
use Aux;

BEGIN {
    use_ok "DNStools::Config" => qw(get_config);
}

can_ok( "DNStools::Config" => "get_config" );

eval { get_config( "xxx|xxx", "yyy|yyy" ) };
ok( $@, "dies on missing config" );

my ( $tmp, %cf );

# prepare some simple sample config
my $c = <<EOF;
# comment
abc = xyz
other =    value with space
EOF
$tmp = Aux::make_config $c;
close($tmp);

# the files is specified, it should find the first
# existing
%cf = get_config( "xxx|xxx", $tmp->filename );
ok( %cf, "got config" );
is( $cf{abc}   => "xyz",            "simple value" );
is( $cf{other} => "valuewithspace", "spaced value" );

# it should find the file specified in $ENV{DNSTOOLS_CONF}
$ENV{DNSTOOLS_CONF} = $tmp->filename;
%cf                 = ();
%cf                 = get_config();
ok( %cf, "got config from \$DNSTOOLS_CONF" );
is( $cf{abc}   => "xyz",            "simple value" );
is( $cf{other} => "valuewithspace", "spaced value" );
