package Aux;

use strict;
use warnings;

use File::Temp;
use base "Exporter";

our $VERSION   = 0.0;
our @EXPORT_OK = qw(make_config);

sub make_config($) {

    my ($c) = @_;

    my $f = File::Temp->new or die "Config file creation failed\n";

    if ( ref $c eq 'HASH' ) {
        map { print $f "$_ = $c->{$_}\n" } keys %{$c};
    }
    elsif ( defined $c ) {

        # assuming just a string
        print $f $c;
    }
    else {

        # make a default configuration
        my ( $bd, $md, $cd );
        for ( $bd, $md, $cd ) {
            my $d = File::Temp::tempdir CLEANUP => 1
              or die "Can't make temporary directory";
            $_ = $d->filename;
        }

        print $f <<__EOF;
bind_dir = $bd
master_dir = $md
zone_conf_dir = $cd

key_counter_end = 15
sign_alert_time = 168
abl_zeit = 24

secondary = hh.schlittermann.de
primary   = pu.schlittermann.de
hostmaster = hostmaster\@schlittermann.de

indexzone = idx.tld
template_dir = ./templates
__EOF

    }

    return $f;

}

1;
