package DNStools::Config;
use strict;
use warnings;

use base "Exporter";

our $VERSION   = 0.0;
our @EXPORT_OK = qw(get_config);

sub get_config(@) {

    # read configuration
    my @configs = @_;
    my %config;

    # the first config FILE
    my ($_) = grep { -f } @configs;
    open(my $cf, $_) or die "Can't open $_: $!\n";

    while (<$cf>) {
        s/#.*//;
        s/\s//g;
        next unless length;
        my ($cname, $ccont) = split(/\s*=\s*/, $_, 2);
        $config{$cname} = $ccont;
    }

    # now merge the config hashes
    foreach my $o (grep { ref eq "HASH" } @configs) {
        %config =
          (%config, map { $_ => $o->{$_} } grep { defined $o->{$_} } keys %$o);
    }
    return %config;
}

1;
