package DNSSec;
use v5.14;
use strict;
use warnings;
use Net::DNS::SEC::Keyset;
use base 'Exporter';

our @EXPORT_OK = qw(keyset ksk keyinfo);


sub keyset {
    my %arg = %{+shift} if ref $_[0] eq ref {};
    my $domain = shift;

    my $resolver = Net::DNS::Resolver->new(
	$arg{-server} ? (nameservers => [$arg{-server}]) : ());
    $resolver->dnssec(1);

    my $keys = $resolver->query($domain => (DNSKEY => 'IN'))
      or die $resolver->errorstring;

    my $ks = Net::DNS::SEC::Keyset->new($keys)
      or die $Net::DNS::SEC::Keyset::keyset_err;
    return $ks;
}

sub ksk {
    return grep { $_->flags & 0x1 } @_;
}

sub keyinfo {
    my $ks = keyset @_;
    my @keyinfo;
    foreach my $k (ksk $ks->keys) {
	my %keyinfo;
	$keyinfo{key} = $k;
	$keyinfo{digest} = Net::DNS::RR::DS->create($k, digtype => 'SHA-256');
	push @keyinfo, \%keyinfo;
    }
    return @keyinfo;
}

1;
