package DNSSec;
use v5.14;
use strict;
use warnings;
use Net::DNS::Keyset;
use base 'Exporter';

our @EXPORT_OK = qw(keyset ksk keyinfo);

my $resolver = Net::DNS::Resolver->new;
$resolver->dnssec(1);

sub keyset {
    my $domain = shift;
    my $keys = $resolver->query($domain => (DNSKEY => 'IN'))
      or die $resolver->errorstring;

    my $ks = Net::DNS::Keyset->new($keys)
      or die $Net::DNS::Keyset::keyset_err;
    return $ks;
}

sub ksk {
    return grep { $_->flags & 0x1 } @_;
}

sub keyinfo {
    my $ks = keyset shift;
    my @keyinfo;
    foreach my $k (ksk $ks->keys) {
	my %keyinfo;
	$keyinfo{key} = $k;
	$keyinfo{digest} = Net::DNS::RR::DS->create($k, digtype => 'SHA-256');
	push @keyinfo, \%keyinfo;
    }
    return @keyinfo;
}

1;
