#!/usr/bin/perl

#    Copyright (C) 2011  Matthias Förste
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    Matthias Förste <foerste@schlittermann.de>

use warnings;

# Using CGI::Fast will result in an Internal Server Error because we are
# restarting apache when everything else works
# use CGI::Fast;
use CGI;
use Ius::Dav::Htpasswd qw(mkpasswd readconfig useradd);

my $css =<<EOC;
body {
        font-family: Helvetica, Arial, sans-serif;
}
h3#header {
    background-color: #d60029;
    color: #fff;
    padding-top: 1em;
    padding-bottom: 1em;
}
EOC

my $q = new CGI;

print $q->header( -charset => 'UTF-8' );
print $q->start_html(
    -title   => $0,
    -style   => { -code => $css },
    -onload  => q{document.forms['passwd'].elements['user'].focus();}
), $q->h3({ -id => 'header' }, 'Befristete WebDAV Zugänge einrichten'), $q->hr;

my ( $user, $pass, $expiry ) =
  ( $q->param('user'), $q->param('pass'), $q->param('expiry') );

print $q->start_form(-id => 'passwd'),
  $q->table(
      $q->Tr(
          $q->td('Nutzername'),
          $q->td($q->textfield('user'))
      ),
      $q->Tr(
          $q->td('Gültigkeitsdauer in Tagen (default: 1)'),
          $q->td($q->textfield('expiry'))
      ),
      $q->Tr(
          $q->td($q->submit({ -name => 'add', -value => 'Anlegen' })),
          $q->td($q->submit({ -name => 'del', -value => 'Löschen' }))
      )
  ),
  $q->end_form;

my $doit = 0;
for ($user, $pass, $expiry) { $doit = 1 and last if defined and $_ ne ''; }

if ($doit) {

    my $conf = readconfig or die "Can't readconfig"; 
    my $add = $q->param('add');
    my $del = $q->param('del');

    if ($add) {

        print $q->hr;
        my @cmd = ( qw(sudo ius-dav-htuseradd -u), $user );
        push @cmd, '-e', $expiry if defined $expiry and $expiry ne '';

        if ( my $pass = qx(@cmd) ) {

            my $url = "$conf->{dav_base_remote}/$user";

            chomp $pass;

            print $q->table(
                $q->Tr(
                    $q->td('Url:'),
                    $q->td($q->a({ -href => $url }, $url))
                ),
                $q->Tr(
                    $q->td('Passwort:'),
                    $q->td($pass)
                )
            );


        }
        else {
            print $q->p('Something went wrong');
        }

    } elsif ($del) {

        my @cmd = ( qw(sudo ius-dav-htuserdel -u), $user );
        print $q->hr, $q->p('Something went wrong') if system @cmd;

    } else {

        # should not happen
        print $q->hr, $q->('Something went wrong');

    }

}

print $q->hr, $q->end_html;
